<?php

/**
 * Class that operate on table 'storerawmaterials'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class StorerawmaterialsMySqlDAO implements StorerawmaterialsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return StorerawmaterialsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM storerawmaterials WHERE storerawmaterialsid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM storerawmaterials';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM storerawmaterials ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param storerawmaterial primary key
     */
    public function delete($storerawmaterialsid) {
        $sql = 'DELETE FROM storerawmaterials WHERE storerawmaterialsid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($storerawmaterialsid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param StorerawmaterialsMySql storerawmaterial
     */
    public function insert($storerawmaterial) {
        $sql = 'INSERT INTO storerawmaterials (storerawmaterialsname, storerawmaterialsdescription, tempdelete, currentdate) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($storerawmaterial->storerawmaterialsname);
        $sqlQuery->set($storerawmaterial->storerawmaterialsdescription);
        $sqlQuery->setNumber($storerawmaterial->tempdelete);
        $sqlQuery->set($storerawmaterial->currentdate);

        $id = $this->executeInsert($sqlQuery);
        $storerawmaterial->storerawmaterialsid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param StorerawmaterialsMySql storerawmaterial
     */
    public function update($storerawmaterial) {
        $sql = 'UPDATE storerawmaterials SET storerawmaterialsname = ?, storerawmaterialsdescription = ?, tempdelete = ?, currentdate = ? WHERE storerawmaterialsid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($storerawmaterial->storerawmaterialsname);
        $sqlQuery->set($storerawmaterial->storerawmaterialsdescription);
        $sqlQuery->setNumber($storerawmaterial->tempdelete);
        $sqlQuery->set($storerawmaterial->currentdate);

        $sqlQuery->setNumber($storerawmaterial->storerawmaterialsid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM storerawmaterials';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStorerawmaterialsname($value) {
        $sql = 'SELECT * FROM storerawmaterials WHERE storerawmaterialsname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStorerawmaterialsdescription($value) {
        $sql = 'SELECT * FROM storerawmaterials WHERE storerawmaterialsdescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdelete($value) {
        $sql = 'SELECT * FROM storerawmaterials WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentdate($value) {
        $sql = 'SELECT * FROM storerawmaterials WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByStorerawmaterialsname($value) {
        $sql = 'DELETE FROM storerawmaterials WHERE storerawmaterialsname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStorerawmaterialsdescription($value) {
        $sql = 'DELETE FROM storerawmaterials WHERE storerawmaterialsdescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdelete($value) {
        $sql = 'DELETE FROM storerawmaterials WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentdate($value) {
        $sql = 'DELETE FROM storerawmaterials WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return StorerawmaterialsMySql
     */
    protected function readRow($row) {
        $storerawmaterial = new Storerawmaterial();

        $storerawmaterial->storerawmaterialsid = isset($row['storerawmaterialsid']) ? $row['storerawmaterialsid'] : '';
        $storerawmaterial->storerawmaterialsname = isset($row['storerawmaterialsname']) ? $row['storerawmaterialsname'] : '';
        $storerawmaterial->storerawmaterialsdescription = isset($row['storerawmaterialsdescription']) ? $row['storerawmaterialsdescription'] : '';
        $storerawmaterial->tempdelete = isset($row['tempdelete']) ? $row['tempdelete'] : '';
        $storerawmaterial->currentdate = isset($row['currentdate']) ? $row['currentdate'] : '';

        return $storerawmaterial;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return StorerawmaterialsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>